import matplotlib.pyplot as plt
import numpy as np
import subfunctions as sf
from scipy.optimize import root_scalar

rover = {'wheel_assembly': {'wheel': {'radius': 0.3, 'mass': 1},
                            'speed_reducer': {'type': 'reverted', 'diam_pinion': 0.05, 'diam_gear': 0.08, 'mass': 1.50},
                            'motor': {'torque_stall': 175, 'torque_noload': 0, 'speed_noload': 3.9, 'mass': 5}},
         'chassis': {'mass': 659}, 'science_payload': {'mass': 75}, 'power_subsys': {'mass': 90}}
planet = {'g': 3.72}

crr = 0.3
slope_array_deg = np.linspace(-15, 45, 25)
v_max = []
for i in range(len(slope_array_deg)):
    angle = slope_array_deg[i]
    fx = lambda x: sf.F_net(x, angle, rover, planet, crr)
    ans = root_scalar(fx, method='bisect', bracket=[-1,4])
    w_max = ans.root
    r = rover['wheel_assembly']['wheel']['radius']
    v_max_value = r * w_max
    v_max.append(v_max_value)

plt.plot(slope_array_deg, v_max)
plt.title('Terrain Angle Analysis')
plt.xlabel('Terrain Angle (degrees)')
plt.ylabel('Maximum Velocity (m/s)')
plt.show()
